import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getFilterConditions,
  getRecord,
} from "../helper/general.js";
import CriticalSystemAffected from "../sequelize/CriticalSystemAffectedSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update CriticalSystemAffected */
export const createUpdateCriticalSystemAffected = async (req, res) => {
  const { id, name, description, department, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "CriticalSystemAffected",
      "critical_system_affected",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "critical_system_affected",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(
        res,
        400,
        "Critical System Affected name already exist"
      );
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "Critical System Affected name name  already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(
      CriticalSystemAffected,
      req.body
    );
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "CriticalSystemAffected",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(
      CriticalSystemAffected,
      req.body
    );
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "CriticalSystemAffected",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(CriticalSystemAffected, req.body.organization, req.body, req.user);
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "CriticalSystemAffected",
  //     `This user updated CriticalSystemAffected with id: ${id}`
  //   );
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   if (!id) {
  //     const unique_id = await uniqueIdGenerator(
  //       req.body.organization,
  //       department,
  //       "CSA",
  //       "critical_system_affected",
  //       "unique_id",
  //       "unique_id"
  //     );
  //     req.body.unique_id = unique_id;
  //   }
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(
  //       `SELECT name FROM critical_system_affected WHERE name = ? AND deleted = 0 AND organization = ?`,
  //       [name, org]
  //     );
  //     if (checkName.length === 0) {
  //       await db.query(
  //         `INSERT INTO critical_system_affected (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`,
  //         [name, encodedDescription, req.user.sessionid, org, req.body.unique_id]
  //       );
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "CriticalSystemAffected",
  //         `This user created a new CriticalSystemAffected '${name}' for organization ${org}`
  //       );
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single CriticalSystemAffected */
export const viewCriticalSystemAffected = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "critical_system_affected"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "critical_system_affected.name",
    "critical_system_affected.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = critical_system_affected.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let criticalSystemAffectedQuery = `SELECT 
  critical_system_affected.*, 
  critical_system_affected.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM critical_system_affected
${joinsRecord} 
WHERE critical_system_affected.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [criticalSystemAffected] = await db.query(criticalSystemAffectedQuery);
  criticalSystemAffected = await getListingData(criticalSystemAffected);
  /**Count all organization */
  const totalRecord = await countQueryCondition(criticalSystemAffectedQuery);
  return sendResponse(res, 200, criticalSystemAffected, totalRecord);

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "critical_system_affected",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "critical_system_affected.name",
  //   "critical_system_affected.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = critical_system_affected.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = critical_system_affected.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT critical_system_affected.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM critical_system_affected ${joinsRecord} WHERE critical_system_affected.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM critical_system_affected WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete CriticalSystemAffected */
export const deleteCriticalSystemAffected = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord(
    "critical_system_affected",
    id
  );
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "CriticalSystemAffected",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
