import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  getFilterConditions,
  getListingData,
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/general.js";
import Currency from "../sequelize/CurrencySchema.js";

/** Function to create or update Currency */
export const createUpdateCurrency = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }

    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "CR",
      "currency",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(Currency, req.body) : createQueryBuilder(Currency, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "Currency", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateCurrency = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       Currency,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Currency",
//       `This user updated Currency with id: ${id}`
//     );
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(
//         `SELECT name FROM currency WHERE name = ? AND deleted = 0 AND organization = ?`,
//         [name, org]
//       );
//       if (checkName.length === 0) {
//           const unique_id = await uniqueIdGenerator(
//             org,
//             req.body?.department || null,
//             "CR",
//             "currency",
//             "unique_id",
//             "unique_id"
//           );

//         await db.query(
//           `INSERT INTO currency (name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`,
//           [name, encodedDescription, req.user.sessionid, org,unique_id]
//         );
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Currency",
//           `This user created a new Currency '${name}' for organization ${org}`
//         );
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single Currency */
export const viewCurrency = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "currency");

  const searchFields = ["currency.name", "currency.description", "users.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = currency.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT currency.*, CONCAT(users.name, ' ', users.surname) AS created_by,currency.organization AS organizations FROM currency ${joinsRecord} WHERE currency.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete Currency */
export const deleteCurrency = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("currency", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "Currency", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
