import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import Disability from "../sequelize/DisabilitySchema.js";
import { sendResponse } from "../helper/wrapper.js";

// export const createUpdateDisability = async (req, res) => {
// let { id, description, organization } = req.body;

// req.body.description = await encodeSingle_statement(description);

// req.body[req.body.id ? "updated_by" : "created_by"] = req.user.sessionid;

// /**If id comes in body then it will update the query */
// if (id) {
//   if (organization.length === 0) {
//     return sendResponse(res, 404, "Please Select at least one business Structure");
//   }
//   const result = await settingsUpdater(
//     Disability,
//     organization,
//     req.body,
//     req.user
//   );
//   if (!result) {
//     return sendResponse(res, 404, "No data found");
//   }

//   await insertActivityLog(
//     req.user.sessionid,
//     "update",
//     "Disability",
//     `This user Update Disability which id is ${id}`
//   );

//   return sendResponse(res, 200, "Record updated successfully");
// } else {
//   const insertPromises = organization.map(async (element) => {
//     // Check if the category type already exists for the organization
//     const [checkNameWithOrganization] = await db.query(
//       `SELECT name FROM disability WHERE name = ? AND deleted = "0" AND organization = ?`,
//       [req.body.name, element]
//     );
//     if (req.body.parent) {
//       const [checkName] = await db.query(`SELECT name FROM disability WHERE id = ${req.body.parent}`);
//       const [newParent] = await db.query(
//         `SELECT id FROM disability WHERE name  = '${checkName[0].name}' AND organization = ${element}`
//       );
//       req.body.parent = newParent[0].id;
//     }

//     req.body.organization = element;
//     if (checkNameWithOrganization.length === 0) {
//       const unique_id = await uniqueIdGenerator(
//         req.body.organization,
//         req.body?.department || null,
//         "Disability",
//         "disability",
//         "unique_id",
//         "unique_id"
//       );
//       req.body.unique_id = unique_id;

//       const { query, values } = createQueryBuilder(Disability, {
//         ...req.body,
//         organization: element,
//       });
//       // console.log(query, values);
//       await db.query(query, values);

//       // Insert record for activity log
//       await insertActivityLog(
//         req.user.sessionid,
//         "create",
//         "Disability",
//         `This user created a new disability${req.body.name}' for this organization ${element}`
//       );
//     }
//   });

//   await Promise.all(insertPromises);

//   return sendResponse(res, 200, "Record created successfully");
// }
// };

export const createUpdateDisability = async (req, res) => {
  const { id, organization,name,description } = req.body;


  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Disability",
      "disability",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "disability",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Disability name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Disability name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(Disability, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "Disability", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(Disability, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Disability",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }








  // if (id && organization.length === 0) {
  //   return sendResponse(res, 404, "Please Select at least one business Structure");
  // }

  // if (!id) {
  //   const result = await getFirstCreatedAndAllOrganizationIds();

  //   if (!result.firstOrgId) {
  //     return sendResponse(res, 404, "No organization found.");
  //   }
  //   const unique_id = await uniqueIdGenerator(
  //     result.firstOrgId,
  //     req.body?.department || null,
  //     "Disability",
  //     "disability",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  // }

  // let status = id ? "Updated" : "Created";
  // req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  // req.body = await encodeAndStringifyFields(req.body);
  // const { query, values } = id ? updateQueryBuilder(Disability, req.body) : createQueryBuilder(Disability, req.body);
  // const [result] = await db.query(query, values);
  // await insertActivityLog(req.user.sessionid, status, "Disability", id ? id : result.insertId);
  // return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all and single Disability */
export const viewDisability = async (req, res) => {
  
  
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "disability"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "disability.name",
    "disability.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = disability.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let disabilityQuery = `SELECT 
  disability.*, 
  disability.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM disability
${joinsRecord} 
WHERE disability.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // console.log(skillQuery, "skillQuery");
  let [disability] = await db.query(disabilityQuery);
  disability = await getListingData(disability);
  /**Count all organization */
  const totalRecord = await countQueryCondition(disabilityQuery);
  return sendResponse(res, 200, disability, totalRecord);

  
  
  
  
  
  
  
  
  
  
  
  
  
  
  // let { organizationCondition, condition } = await getFilterConditions(req, db, "disability");

  // const searchTableName = ["disability.name", "disability.description", "CONCAT(users.name , ' ' , users.surname)"];
  // let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = disability.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "disability AS parent_disability",
  //     onCondition: "parent_disability.id = disability.parent",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const DisabilityQuery = `SELECT disability.unique_id, disability.id, disability.created_by as created_by_id, disability.name,parent_disability.name AS parent_name , disability.description, users.name as created_by, users.surname as created_by_surname, users.profile as created_by_profile,disability.organization as organizations, disability.parent FROM disability ${joinsRecord} WHERE disability.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // let [Disability] = await db.query(DisabilityQuery);

  // Disability = await getListingData(Disability);

  // async function fetchSubChildren(parentId) {
  //   const [subChildren] = await db.query(`SELECT * FROM disability WHERE deleted = 0 AND parent = ?`, [parentId]);

  //   // Only populate sub-children if any are found, and no need to recurse if not needed
  //   for (const child of subChildren) {
  //     child.description = await decodeSingle_statement(child.description);
  //     child.sub_children = await fetchSubChildren(child.id);
  //   }
  //   return subChildren;
  // }

  // const nestedDisability = [];

  // for (const item of Disability) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (item.parent === null) {
  //     item.sub_children = await fetchSubChildren(item.id);
  //     nestedDisability.push(item);
  //   }
  // }

  // const totalRecord = await countQueryCondition(DisabilityQuery);
  // return sendResponse(res, 200, nestedDisability, totalRecord);
};

export const viewDisabilityDropDown = async (req, res) => {
  try {
    // const { page = 1, pageSize = 10 } = req.query;
    // const offset = (page - 1) * pageSize;

    // parent records
    let fetchParentQuery = `
      SELECT id, name, parent, organization 
      FROM disability 
      WHERE deleted = 0 AND parent IS NULL
    `;
    let [parentRecords] = await db.query(fetchParentQuery);

    if (parentRecords.length === 0) {
      return sendResponse(res, 200, []);
    }

    const fetchChildrenRecursively = async (parentId) => {
      let fetchChildQuery = `
        SELECT id, name, parent, organization 
        FROM disability 
        WHERE deleted = 0 AND parent = ?
      `;
      const [children] = await db.query(fetchChildQuery, [parentId]);

      for (const child of children) {
        const grandchildren = await fetchChildrenRecursively(child.id);
        children.push(...grandchildren);
      }
      return children;
    };

    for (const parent of parentRecords) {
      const children = await fetchChildrenRecursively(parent.id);
      parentRecords.push(...children);
    }
    parentRecords = await decodeAndParseFields(parentRecords);
    return sendResponse(res, 200, parentRecords);
  } catch (error) {
    console.error("Error fetching disability dropdown data:", error);
    return sendResponse(res, 500, { error: "Internal Server Error" });
  }
};

export const getParentDisabilityList = async (req, res) => {
  let { filter } = req.query;
  filter = typeof filter === "string" ? JSON.parse(filter) : filter;
  let { organizations } = filter;
  if (!organizations || organizations.length == 0) {
    const [arrOrg] = await db.query(`SELECT id FROM organization WHERE deleted = 0`);
    organizations = arrOrg.map((item) => item.id);
    // return sendResponse(res, 400, "organizations is required");
  }
  // console.log(organizations);
  organizations = typeof organizations == "string" ? JSON.parse(organizations) : organizations;

  const disabilityQuery = `
    SELECT *
    FROM disability
    WHERE 
        ${organizations.map(() => `JSON_CONTAINS(organization, CAST(? AS JSON), '$')`).join(" AND ")}
        AND deleted = 0;
`;

  const params = [...organizations];
  const [parentDisabilityList] = await db.query(disabilityQuery, params);
  // const uniqueObj = {};
  // parentDisabilityList.forEach((item) => {
  //   if (!uniqueObj[item.name]) {
  //     uniqueObj[item.name] = item;
  //   }
  // });
  // const uniqueArr = Object.values(uniqueObj);
  // console.log(uniqueArr);
  // return uniqueArr;

  return sendResponse(res, 200, parentDisabilityList);
};

/**Function to delete a specific Disability */
export const deleteDisability = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("disability", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Disability", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
