import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import FinancialYear from "../sequelize/FinancialYearSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create new Financial Year for employee  */
export const createUpdateFinancialYear = async (req, res) => {
  const { id, description, organization } = req.body;

  if (id) {
    if (organization.length === 0) {
      return sendResponse(res, 200, "Please select at least one business structure");
    }
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "FinancialYear",
      "financial_year",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(FinancialYear, req.body)
    : createQueryBuilder(FinancialYear, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "FinancialYear", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateFinancialYear = async (req, res) => {
//   const { id, name, description, organization } = req.body;

//   const encodedDescription = await encodeSingle_statement(description);

//   /**If id comes in body then it will update the query */
//   if (id) {
//     if (organization.length === 0) {
//       return sendResponse(res, 200, "Please select at least one business structure");
//     }
//     const result = await settingsUpdater(FinancialYear, organization, req.body, req.user);
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }

//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Financial Year",
//       `This user Update Financial Year which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /** Insert new record */
//     const insertPromises = organization.map(async (element) => {
//       // Check if the category type already exists for the organization
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM financial_year WHERE name = ? AND deleted = "0" AND organization = ?`,
//         [name, element]
//       );

//       // If record not found for that name with particular organization, insert the record
//       if (checkNameWithOrganization.length === 0) {
//         const unique_id = await uniqueIdGenerator(
//           element,
//           req?.body?.department || null,
//           "FinancialYear",
//           "financial_year",
//           "unique_id",
//           "unique_id"
//         );

//         // Insert Financial Year details
//         const insertFinancialYearQuery = `INSERT INTO financial_year(name, description, created_by, organization,unique_id) VALUES (?, ?, ?, ?,?)`;
//         await db.query(insertFinancialYearQuery, [name, encodedDescription, req.user.sessionid, element, unique_id]);

//         // Insert record for activity log
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Financial Year",
//           `This user created a new category '${name}' for this organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all and single Financial Year */
export const viewFinancialYear = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "financial_year");

  const searchTableName = [
    "financial_year.name",
    "financial_year.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = financial_year.created_by",
    },

    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = financial_year.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const FinancialYearQuery = `SELECT financial_year.*,financial_year.name AS financial_year ,  users.id AS created_by_id, users.name AS created_by, financial_year.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM financial_year ${joinsRecord} where financial_year.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // return console.log(
  //   FinancialYearQuery,
  //   "FinancialYearQuery"
  // );
  let [FinancialYearRecord] = await db.query(FinancialYearQuery);

  FinancialYearRecord = await getListingData(FinancialYearRecord);

  /**Count all organization */
  const totalRecord = await countQueryCondition(FinancialYearQuery);

  return sendResponse(res, 200, FinancialYearRecord, totalRecord);
};

/**Function to delete a specific Financial Year */
export const deleteFinancialYear = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("financial_year", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Financial Year", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
