import {
  countQueryCondition,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteRecord,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import InfrastructureTechnicalForm from "../sequelize/InfrastructureTechnicalFormSchema.js";
import db from "../db-config.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create Safety Incident Form  */
export const createInfrastructureTechnicalForm = async (req, res) => {
  const { id } = req.body;
  // console.log(req.body, "dhb");
  const sessionId = req.user.sessionid;
  let organizationId = req.body.organization;
  const { department, comments } = req.body;
  delete req.body.department;

  if (department) {
    const recordAccordingToOrganization = await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0]?.organization;
    if (organizationId) {
      req.body.organization = organizationId;
    }
  }

  req.body.created_by = sessionId;

  const { asset_details, asset_damage_details, asset_type } = req.body;
  req.body.asset_details = JSON.stringify(asset_details);
  req.body.asset_damage_details = JSON.stringify(asset_damage_details);
  req.body.asset_type = JSON.stringify(asset_type);

  if (Array.isArray(asset_type)) {
    const updatedAssets = asset_type.map((ele, index) => {
      const { condition, status, select_asset } = ele;
      if (select_asset) {
        return db.query(
          `UPDATE asset SET conditions = '${condition}', status = '${status}' WHERE id = ${select_asset}`
        );
      }
    });
    await Promise.all(updatedAssets);
  }

  const { query, values } = id
    ? updateQueryBuilder(InfrastructureTechnicalForm, req.body)
    : createQueryBuilder(InfrastructureTechnicalForm, req.body);
  const [createInfrastructureForm] = await db.query(query, values);
  if (!id && createInfrastructureForm.insertId === 0) {
    return sendResponse(res, 404, "Cannot create record");
  }

  await insertActivityLog(
    req.user.sessionid,
    "create",
    "Infrastructure Technical Form",
    `This user created a new Infrastructure Technical Form Record for organization ${organizationId}`
  );

  return sendResponse(res, 200, "Record created successfully");
};

export const getInfrastructureTechnicalForm = async (req, res) => {
  const { type } = req.query;
  const { id } = req.params;
  const condition = await whereCondition({
    table: "infrastructure_technical_form",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
    columnName: type,
  });
  const searchTableName = [
    "infrastructure_technical_form.type_of_property_asset_damaged",
    "infrastructure_technical_form.specify_property_asset_damaged",
    "infrastructure_technical_form.property_damaged_details",
    "infrastructure_technical_form.select_property_damaged",
    "infrastructure_technical_form.specify_property_damaged",
    "infrastructure_technical_form.name_of_insurer",
    "infrastructure_technical_form.form_submitted_by",
    "infrastructure_technical_form.claim_no_insurer",
    "infrastructure_technical_form.name_of_police_station",
    "infrastructure_technical_form.case_no_saps",
    "infrastructure_technical_form.name_of_contact_person",
    "infrastructure_technical_form.contact_details",
    "infrastructure_technical_form.comments",
    "infrastructure_technical_form.form_completed_by",
    "infrastructure_technical_form.designation",
    "infrastructure_technical_form.signature",
    "organization.name",
    "department.name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = infrastructure_technical_form.created_by",
    },
    {
      type: "left",
      targetTable: "users as employee",
      onCondition: "employee.id = infrastructure_technical_form.form_submitted_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = infrastructure_technical_form.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = infrastructure_technical_form.department",
    },
    {
      type: "left",
      targetTable: "department as employeeDepartment",
      onCondition: "employee.department = employeeDepartment.id",
    },
  ];
  const joinCondition = await makeJoins(joins);
  const infrastructureTechnicalFormQuery = `SELECT infrastructure_technical_form.* , organization.name as organization_name ,employeeDepartment.name as department_name , users.name as created_by_name , users.surname as created_by_surname  , users.profile as created_by_profile   FROM infrastructure_technical_form ${joinCondition} WHERE infrastructure_technical_form.deleted = 0 ${condition} ${searchCondition}`;
  const totalRecord = await countQueryCondition(infrastructureTechnicalFormQuery);

  let [infrastructureTechnicalForm] = await db.query(infrastructureTechnicalFormQuery);

  infrastructureTechnicalForm = await decodeAndParseFields(infrastructureTechnicalForm);

  return sendResponse(res, 200, infrastructureTechnicalForm, totalRecord);
};

export const deleteInfrastructureTechnicalForm = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord("infrastructure_technical_form", id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Infrastructure Technical Form",
      `This user deleted a new Infrastructure Technical Form Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 404, "Cannot delete record");
};
