import db from "../db-config.js";
import { uploadToDDRM } from "../helper/ddrmUploader.js";
import {
  addLegislationDoc,
  countQueryCondition,
  deleteRecord,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  whereCondition,
  storeError,
  uploadFile,
  searchConditionRecord,
  processUploadDocuments,
  decodeAndParseFields,
  uniqueIdGenerator,
  createQueryBuilder,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import Legislation from "../sequelize/LegislationSchema.js"; // for sync purpose only not to be removed
import LegislationDoc from "../sequelize/LegislationDocSchema.js"; // for sync purpose only not to be removed
/**Function to create new Legislation  */
export const createUpdateLegislation = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];
  const {
    id,
    she_legislation,
    organization,
    department,
    sidebar_id = 123,
  } = req.body;
  const updated_image = req.files && req.files.updated_image;
  let organizationId = organization;
  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0].organization;
  }
  const documents = await processUploadDocuments(req, sidebar_id, "document_file");

  if (id && documents.length) {
    const deleteQuery = `UPDATE legislation_doc SET deleted = 1 where deleted = 0 AND legislation_id = ?`;
    await db.query(deleteQuery, [id]);
  }
  /**If id comes in body then it will update the query */
  if (id) {
    
    /**Update record for Meeting Recording */
    const updateLegislationQuery = `UPDATE legislation SET she_legislation = ? ,  organization = ?, department = ?, updated_by = ? WHERE id = ?`;
    const updateLegislationValues = [
      she_legislation,
      organizationId,
      department,
      req.user.sessionid,
      id
    ];
    const [updateLegislation] = await db.query(
      updateLegislationQuery,
      updateLegislationValues
    );

    if (documents || Array.isArray(documents)) {
      // Iterate through uploaded files
      for (const file of documents) {
        const ddrm_id = file?.ddrm_id;
        const id_doc = file.id;
        // Move the file to the public folder
        // Save file details for database
        const { query: docQuery, values: docValues } = createQueryBuilder(
          LegislationDoc,
          {
            doc_no: id_doc,
            legislation_id: id,
            ddrm_id,
          }
        );
  
        await db.query(docQuery, docValues);
      }
    }
    /**Insert Activity  */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "Legislation",
      id
    );
    
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      department,
      "LEG",
      "legislation",
      "unique_id",
      "unique_id"
    );
    /**Insert record for Legislation */
    const createLegislationQuery = `INSERT INTO legislation (she_legislation, organization, department ,created_by, unique_id) VALUES (?, ?, ?, ?, ?);`;
    const createLegislationValues = [
      she_legislation,
      organizationId,
      department,
      req.user.sessionid,
      unique_id,
    ];
    const [createLegislation] = await db.query(
      createLegislationQuery,
      createLegislationValues
    );
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Legislation",
      createLegislation.insertId
    );
    await addLegislationDoc(
      createLegislation.insertId,
      organizationId,
      department,
      req
    );
    return sendResponse(res, 200, "Record created successfully");
  }
};
// export const createUpdateLegislation = async (req, res) => {
//   req.body = (await decodeAndParseFields([req.body]))[0];
//   const {
//     id,
//     she_legislation,
//     organization,
//     department,
//     sidebar_id = 123,
//   } = req.body;
//   const updated_image = req.files && req.files.updated_image;
//   let organizationId = organization;
//   if (department) {
//     const recordAccordingToOrganization =
//       await getOrganizationAccordingToDepartment(department);
//     organizationId = recordAccordingToOrganization[0].organization;
//   }
//   const documents = await processUploadDocuments(req, sidebar_id, "document_file");
//   console.log('documents: ', documents);

//   if (id && documents.length) {
//     const deleteQuery = `UPDATE legislation_doc SET deleted = 1 where deleted = 0 AND legislation_id = ?`;
//     await db.query(deleteQuery, [id]);
//   }
//   /**If id comes in body then it will update the query */
//   if (id) {
//     /**Find older version of docs */
//     const [lastDocsVersion] = await db.query(
//       `SELECT legislation_id, new_version FROM legislation_doc WHERE legislation_id=${id} AND deleted = "0"`
//     );
//     console.log("lastDocsVersion: ", lastDocsVersion);
//     /**Get last version of docs */
//     const [lastLatestDocsVersion] = await db.query(
//       `SELECT new_version FROM legislation_doc WHERE legislation_id=${lastDocsVersion[0].legislation_id} order by id desc limit 1`
//     );
//     const currentVersion = parseFloat(
//       lastLatestDocsVersion[0]?.new_version || 0.0
//     );
//     const incrementedVersion = currentVersion + 0.001;
//     /**Check that profile has been uploaded or not */
//     if (updated_image) {
//       // const updatePath = await uploadFile("legislation_doc", updated_image);
//       const ddrm_id = await uploadToDDRM(sidebar_id, updated_image, req);
//       /**Insert record for Legislation docs */
//       const createLegislationQuery = `INSERT INTO legislation_doc (legislation_id ,old_version , new_version , ddrm_id, organization , department ) VALUES (?,?, ? ,? ,? ,?, ?)`;
//       const createLegislationValues = [
//         lastDocsVersion[0]?.legislation_id,
//         currentVersion,
//         incrementedVersion,
//         ddrm_id,
//         organizationId,
//         department,
//       ];
//       const [createLegislation] = await db.query(
//         createLegislationQuery,
//         createLegislationValues
//       );
//     } else {
//       /**update title in docs */
//       // const createLegislationQuery = `UPDATE legislation_doc SET document_title = ? WHERE id = ?`;
//       // const createLegislationValues = [document_title, id];
//       // const [createLegislation] = await db.query(
//       //   createLegislationQuery,
//       //   createLegislationValues
//       // );
//     }
//     /**Update record for Meeting Recording */
//     const updateLegislationQuery = `UPDATE legislation SET she_legislation = ? ,  organization = ?, department = ?, updated_by = ? WHERE id = ?`;
//     const updateLegislationValues = [
//       she_legislation,
//       organizationId,
//       department,
//       req.user.sessionid,
//       lastDocsVersion[0].legislation_id,
//     ];
//     const [updateLegislation] = await db.query(
//       updateLegislationQuery,
//       updateLegislationValues
//     );
//     /**Insert Activity  */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Legislation",
//       lastDocsVersion[0].legislation_id
//     );
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Legislation Docs",
//       id
//     );
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const unique_id = await uniqueIdGenerator(
//       req.body.organization,
//       department,
//       "LEG",
//       "legislation",
//       "unique_id",
//       "unique_id"
//     );
//     /**Insert record for Legislation */
//     const createLegislationQuery = `INSERT INTO legislation (she_legislation, organization, department ,created_by, unique_id) VALUES (?, ?, ?, ?, ?);`;
//     const createLegislationValues = [
//       she_legislation,
//       organizationId,
//       department,
//       req.user.sessionid,
//       unique_id,
//     ];
//     const [createLegislation] = await db.query(
//       createLegislationQuery,
//       createLegislationValues
//     );
//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "create",
//       "Legislation",
//       createLegislation.insertId
//     );
//     await addLegislationDoc(
//       createLegislation.insertId,
//       organizationId,
//       department,
//       req
//     );
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };
/**Function to view all and single Legislation */
export const viewLegislation = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "legislation",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });
  const searchTableName = [
    "legislation.she_legislation",
    "CONCAT(users.name , ' ' , users.surname)",
    // "legislation_doc.document_title",
    "organization.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    // {
    //   type: "left",
    //   targetTable: "legislation",
    //   onCondition: "legislation.id = legislation_doc.legislation_id",
    // },
    // {
    //   type: "left",
    //   targetTable: "repository",
    //   onCondition: "repository.id = legislation_doc.ddrm_id",
    // },
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = legislation.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = legislation.organization",
    },
    {
      type: "left",
      targetTable: "she_legal_register",
      onCondition: "she_legal_register.id = legislation.she_legislation",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all roles */
  const legislationRecordQuery = `SELECT legislation.*, legislation.she_legislation, legislation.unique_id, she_legal_register.title AS she_legislation_name,legislation.created_by as created_by_id,legislation.organization,organization.name as organization_name,users.name as created_by,users.profile as created_by_profile ,users.surname as created_by_surname ,legislation.organization FROM legislation ${joinsRecord} where legislation.deleted = 0 ${searchCondition} ${condition}`;
  const [legislationRecord] = await db.query(legislationRecordQuery);

  for(let legislation of legislationRecord){
    const [files] = await db.query(
      `SELECT legislation_doc.*, repository.url as file, document_name as title FROM legislation_doc LEFT JOIN repository ON repository.id = legislation_doc.ddrm_id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE legislation_doc.deleted = 0 AND legislation_id = ${legislation.id}`
    );
    legislation.document_file = files.length
      ? files
      : [{ title: "", ddrm_id: null, file: null }];
  }
  const totalRecord = await countQueryCondition(legislationRecordQuery);
  return sendResponse(res, 200, legislationRecord, totalRecord);
};
/**Function to delete a specific Legislation */
export const deleteLegislation = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord("legislation_doc", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "legislation Document",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
