import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  getCompanyName,
  getRecord,
  inWhereFormat,
  insertActivityLog,
  isTeamLeader,
  storeError,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import { getMeetingRecordById } from "./meetingRecordingController.js";
import moment from "moment";
import sendEmail from "../helper/sendEmail.js";

/**Function to view all meeting recording approval */
export const viewAllMeetingApproval = asyncHandler(async (req, res) => {
  try {
    const { id } = req.params;

    const { business, scheduled_meeting } = req.query;

    let where = id ? `AND meeting_recording.id = ${id}` : "";

    let extraFilter = business
      ? scheduled_meeting
        ? `AND meeting_recording.organization = ${business} 
           AND meeting_recording.scheduled_meeting = ${scheduled_meeting}`
        : `AND meeting_recording.organization = ${business}`
      : ``;

    /** If searching for status based filter then also filter on the basis of scriber based filter */

    let status = req.query.status
      ? `AND meeting_recording.status = '${req.query.status}' AND meeting_recording.meeting_scriber = ${req.user.sessionid}`
      : `AND meeting_recording.meeting_scriber = ${req.user.sessionid} AND meeting_recording.status !=0`;

    const page = parseInt(req.query.page) || 1;

    const pageSize = parseInt(req.query.pageSize) || 10;

    const offset = (page - 1) * pageSize;

    const all = req.query.all;

    const searchWord = req.query.search || "";

    /** filter on the basis of leader or not */

    const leaderFilter = await isTeamLeader(
      req.user.sessionid,
      "meeting_recording",
      "meeting_recording"
    );

    /**Check multiple users organization */
    const organization = await inWhereFormat(req.additionalData);
    // return console.log(organization)
    /**Check if login person is super admin of that organization then show all record */
    const isSuperAdmin =
      req.user.sessionidRole == 0
        ? `AND meeting_recording.organization in ${organization}`
        : `AND meeting_recording.organization in ${organization}`;

    /** If value come with any search condition then search that word */

    // Issue with the meeting id search
    let searchCondition = searchWord
      ? `AND (meeting_recording.meeting_title LIKE '%${searchWord}%' OR meeting_recording.status LIKE '%${req.query.search}%' OR meeting.meeting_id LIKE '%${req.query.search}%' OR meeting.venue LIKE '%${searchWord}%' OR organization.name LIKE '%${searchWord}%' OR u1.name LIKE '%${searchWord}%' OR u2.name LIKE '%${searchWord}%' OR users.name LIKE '%${req.query.search}%')`
      : "";

    /** If query come with pagination then pagination come otherwise show all data*/
    let pagination =
      all === "false" ? `LIMIT ${pageSize} OFFSET ${offset}` : ``;

    /**Record of all meeting */

    let meetingQuery = `SELECT 
    meeting_recording.*, 
    meeting_recording.created_by as created_by_id, 
    meeting_recording.id, 
    meeting_recording.planned_meeting_date_from, 
    meeting_recording.planned_meeting_date_to,
    meeting_recording.organization,
    meeting_recording.scheduled_meeting,
    meeting_recording.status,
    meeting.meeting_title,
    meeting_recording.meeting_title, 
    u1.name as meeting_scriber_name, 
    u2.name as meeting_chairperson_name,
    users.name as created_by, 
    organization.name as organization_name,
    meeting.meetingHost,
    meeting.meetingId,
    meeting.location,
    meeting.meetingType,
    hierarchy.name as name,
    u3.name as meeting_owner_name
FROM 
    meeting_recording 
LEFT JOIN 
    meeting ON meeting.id = meeting_recording.scheduled_meeting 
LEFT JOIN 
    hierarchy ON hierarchy.id = meeting.meetingType
LEFT JOIN 
    users ON users.id = meeting_recording.created_by
LEFT JOIN 
    users AS u1 ON u1.id = meeting_recording.meeting_scriber
LEFT JOIN 
    users AS u2 ON u2.id = meeting_recording.meeting_chairperson
LEFT JOIN 
    organization ON organization.id = meeting_recording.organization 
LEFT JOIN 
    users AS u3 ON meeting.meetingHost = u3.id
WHERE 
    meeting_recording.deleted = 0
    ${where} 
    ${isSuperAdmin} 
    ${searchCondition} 
    ${extraFilter}
    ${leaderFilter}
    ${status}
ORDER BY 
    meeting_recording.id DESC 
    ${pagination}
`;

    // return console.log(meetingQuery)
    const meetingRecordings = await db.query(meetingQuery);
    // return console.log(meetingQuery)
    meetingRecordings.forEach((meet) => {
      meet.participants = [...JSON.parse(meet.participants || "[]")].map(
        (e) => {
          return {
            ...e,
            meetingId: meet.meetingId,
          };
        }
      );
      meet.meeting_notes = [...JSON.parse(meet.meeting_notes || "[]")].map(
        (e) => {
          return {
            ...e,
            meetingId: meet.meetingId,
          };
        }
      );
    });
    const countDataFetch = await db.query(
      `SELECT count(id) as meeting_record_id FROM meeting_recording WHERE deleted = 0 ${isSuperAdmin} ${searchCondition} ${leaderFilter}
      ${extraFilter} ${status}`
    );
    return res.status(200).json({
      status: true,
      data: meetingRecordings,
      total: countDataFetch[0].meeting_record_id,
    });
  } catch (error) {
    /** Check if error is come then send that error to log file  */
    storeError(error);
    res.status(500).json({
      status: false,
      message: error.message,
    });
  }
});

/**Function to specific meeting recording or approval by id */
export const viewAllMeetingApprovalById = asyncHandler(async (req, res) => {
  try {
    const { meetingId } = req.params;

    let where = meetingId ? `AND meeting.meetingId = '${meetingId}'` : "";

    /**Check multiple users organization */
    const organization = await inWhereFormat(req.additionalData);
    // return console.log(organization)
    /**Check if login person is super admin of that organization then show all record */
    let isSuperAdmin =
      req.user.sessionidRole == 0
        ? `AND meeting_recording.organization in ${organization}`
        : `AND meeting_recording.organization in ${organization}`;

    /**Record of all meeting */

    let meetingQuery = `SELECT 
    meeting_recording.*,
    meeting.meetingId,
    meeting_recording.created_by as created_by_id, 
    meeting_recording.id, 
    meeting_recording.planned_meeting_date_from, 
    meeting_recording.planned_meeting_date_to, 
    meeting_recording.organization, 
    meeting_recording.scheduled_meeting, 
    meeting_recording.status,
    meeting.meeting_title, 
    meeting.agenda,
    meeting_recording.meeting_title, 
    u1.name as meeting_scriber_name, 
    u2.name as meeting_chairperson_name, 
    users.name as created_by, 
    organization.name as organization_name, 
    meeting.meetingHost, 
    meeting.location, 
    meeting.meetingType, 
    hierarchy.name as name, 
    u3.name as meeting_owner_name 
FROM 
    meeting_recording 
LEFT JOIN 
    meeting ON meeting.id = meeting_recording.scheduled_meeting 
LEFT JOIN 
    hierarchy ON hierarchy.id = meeting.meetingType 
LEFT JOIN 
    users ON users.id = meeting_recording.created_by 
LEFT JOIN 
    users AS u1 ON u1.id = meeting_recording.meeting_scriber 
LEFT JOIN 
    users AS u2 ON u2.id = meeting_recording.meeting_chairperson 
LEFT JOIN 
    organization ON organization.id = meeting_recording.organization 
LEFT JOIN 
    users AS u3 ON meeting.meetingHost = u3.id 
WHERE 
    meeting_recording.deleted = 0 
    ${where} 
    ${isSuperAdmin}
`;

    const meetingRecordings = await db.query(meetingQuery);

    if (meetingRecordings.length == 0) {
      /** check record of meeting  */
      where = meetingId ? `AND meeting.meetingId = '${meetingId}'` : "";
      isSuperAdmin =
        req.user.sessionidRole == 0
          ? `AND meeting.organization in ${organization}`
          : `AND meeting.organization in ${organization}`;
      const meetQuery = `SELECT meeting.*, meeting.meetingId, meeting.meetingHost as meeting_owner_id, u1.name as meeting_owner_name, u1.profile as meeting_owner_profile, meeting.created_by as created_by_id,meeting.meetingType as meeting_hierarchy_id, hierarchy.name,hierarchy.description,meeting.organization,users.name as created_by, organization.name as organization_name from 
        meeting left join hierarchy on hierarchy.id = meeting.meetingType
        left join users on users.id = meeting.created_by
        left join users as u1 on u1.id = meeting.meetingHost
        left join organization on organization.id = meeting.organization 
        where meeting.deleted = 0 ${where} 
        ${isSuperAdmin}`;
      const meeting = await db.query(meetQuery);
      const meetingArray = [];
      const insertPromise = meeting.map(async (meet) => {
        const participants = meet.participants
          ? JSON.parse(meet.participants || "[]")
          : [];
        let user = [];
        if (participants.length) {
          user = await db.query(
            `SELECT name ,id from users where id In (${participants})`
          );
        }
        meet.participants = user;
        meet.agenda = JSON.parse(meet.agenda || "[]");

        /** check the assigned person of agenda  */
        for (let agenda of meet.agenda) {
          if (agenda.allocated_to) {
            let allocated_person_name = await db.query(
              `SELECT name from users where id = ${agenda.allocated_to}`
            );
            agenda.allocated_person_name = allocated_person_name[0]?.name;
          }
        }
        meetingArray.push(meet);
      });
      await Promise.all(insertPromise);

      return res.status(200).json({
        status: true,
        data: meeting,
      });
    }

    const insertPromise = meetingRecordings.map(async (meet) => {
      meet.participants = JSON.parse(meet.participants || "[]");
      meet.meeting_notes = JSON.parse(meet.meeting_notes);
      meet.agenda = JSON.parse(meet.agenda || "[]");
      /** check the assigned person of agenda  */
      for (let agenda of meet.agenda) {
        if (agenda.allocated_to) {
          let allocated_person_name = await db.query(
            `SELECT name from users where id = ${agenda.allocated_to}`
          );
          agenda.allocated_person_name = allocated_person_name[0]?.name;
        }
      }
      /** check the assigned person of agenda */
      for (let notes of meet.meeting_notes) {
        if (notes.allocated_to) {
          const allocated_person_name = await db.query(
            `SELECT name from users where id = ${notes.allocated_to}`
          );
          notes.allocated_person_name = allocated_person_name[0]?.name;
          notes.title = meet?.agenda.filter(
            (e) => e.id == notes.value
          )[0]?.title;
          notes.canAddComment = notes.allocated_to === req.user.sessionid;
        }
      }
    });

    await Promise.all(insertPromise);

    return res.status(200).json({
      status: true,
      data: meetingRecordings,
    });
  } catch (error) {
    /** Check if error is come then send that error to log file  */
    storeError(error);
    res.status(500).json({
      status: false,
      message: error.message,
    });
  }
});

/**Function to add comment to a specific Meeting Recording approval by scriber */
export const addCommentToMeetingApproval = async (req, res) => {
  const { comment, id, approval_status } = req.body;
  let status = approval_status;
  // already approved or rejected can't be change status
  const [record] = await getRecord("meeting_recording", "id", id);
  if (record.status == "Approved" || record.status == "Rejected") {
    return sendResponse(res, 404, `You can't change status because it is already ${record.status}`);
  }
  let where = req.user.isSuperAdmin
    ? ""
    : `AND meeting_scriber = ${req.user.sessionid} `;
  const query = `UPDATE meeting_recording SET status = ?, comment = ? WHERE id = ?  ${where}`;
  const [addComment] = await db.query(query, [status, comment ?? "", id]);
  console.log('addComment: ', addComment);
  if (addComment.affectedRows === 0) {
    return sendResponse(res, 404, "You haven't access to approve this meeting");
  } else {
    if (approval_status === "Approved") {
      let meetingRecordData = await getMeetingRecordById(id)
      let chairPerson = `${meetingRecordData[0].meeting_owner} ${meetingRecordData[0].meeting_owner_surname}`;
      const proposedStartDate = moment(meetingRecordData[0].actual_meeting_date_from).format("YYYY-MM-DD");
      const proposedStartTime = moment(meetingRecordData[0].actual_meeting_date_from).format("hh:mm A");
      const proposedEndDate = moment(meetingRecordData[0].actual_meeting_date_to).format("YYYY-MM-DD");
      const proposedEndTime = moment(meetingRecordData[0].actual_meeting_date_to).format("hh:mm A");

      const companyDetails = await getCompanyName(meetingRecordData[0].organization)

      let participantDetails = [];
      for (let i = 0; i < meetingRecordData[0]?.participants?.length; i++) {
        const participant = meetingRecordData[0]?.participants[i];

        participantDetails.push({
          fullName: `${participant?.name} ${participant?.surname}`.trim(),
          status: `${participant?.status}`
        });
      }

      let externalParticipantDetails = [];
      for (let i = 0; i < meetingRecordData[0]?.external_guest_details?.length; i++) {
        const externalParticipant = meetingRecordData[0]?.external_guest_details[i];

        externalParticipantDetails.push({
          fullName: `${externalParticipant?.external_guest_first_name} ${externalParticipant?.external_guest_last_name}`.trim()
        });
      }

      let agendaData = [];
      meetingRecordData[0]?.agenda?.forEach((agenda) => {
        agendaData.push({
          title: agenda?.title,
          allocated_name: agenda?.allocated_name,
        });
      });

      let actionData = [];
      meetingRecordData[0]?.notes?.forEach((note) => {
        if (note.actions && Array.isArray(note.actions)) {
          const filteredActions = note?.actions?.map(action => ({
            action_discussion_name: action.action_discussion_name,
            due_date: action.due_date,
            assigned_name: action?.assigned_name
          }));

          actionData.push(...filteredActions);
        }
      });

      const sendMeetingOwnerRecordArray = {
        templateFileUrl: "mail_for_meeting_approval_notification_template.html",
        templateName: "Meeting Approval",
        meeting_chairperson: chairPerson,
        meeting_name: meetingRecordData[0].meeting_title,
        scheduler_name: chairPerson,
        proposed_start_date: proposedStartDate,
        proposed_start_time: proposedStartTime,
        proposed_end_date: proposedEndDate,
        proposed_end_time: proposedEndTime,
        meeting_venue: meetingRecordData[0]?.venue,
        meeting_hierarchy: meetingRecordData[0]?.meeting_hierarchy,
        participantDetails: participantDetails
          .map(participant => `${participant.fullName} - ${participant.status}`)
          .join("<br>"),
        externalParticipantDetails: externalParticipantDetails
          .map(participant => `${participant.fullName}`)
          .join("<br>"),
        agendaData: agendaData
          .map(agenda => `${agenda.title} - ${agenda.allocated_name}`)
          .join("<br>"),
        actionData: `
           <table border="1" cellspacing="0" cellpadding="5" style="width:100%; border-collapse: collapse;">
              <thead>
                <tr style="background-color: #004080; color: white;">
                  <th>Action Discussion</th>
                  <th>Allocated To</th>
                  <th>Due Date</th>
                </tr>
              </thead>
              <tbody>
              ${actionData
            .map(action => `
                  <tr>
                    <td>${action?.action_discussion_name || " "}</td>
                    <td>${action?.assigned_name || " "}</td>
                    <td>${action?.due_date || " "}</td>
                  </tr>
                `)
            .join("")
          }
              </tbody>
            </table>
          `,
        company_name: companyDetails?.name,
        company_website: companyDetails?.business_logo,
      };

      const meetingOwnerInfo = await sendEmail(
        "info@harmonyandhelp.com",
        meetingRecordData[0].meeting_owner_email,
        `Approval Required: Meeting Request- ${meetingRecordData[0].meeting_title}`,
        sendMeetingOwnerRecordArray,
      );
    }

    /**Insert record for activity log */
    insertActivityLog(
      req.user.sessionid,
      "add",
      "comment",
      `This user add comment and status for meeting which id is ${id} and status is ${status}`
    );
    return sendResponse(res, 200, `Record ${status} successfully`);
  }
};
