import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  processesSingleDDRMDocument,
  processUploadDocuments,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import OhsFileDocs from "../sequelize/OhsFileAssessmentDocsSchema.js";
import OhsFileAssessment from "../sequelize/OhsFileAssessmentSchema.js";

export const createUpdateOhsFileAssessment = async (req, res) => {
  let { id, values: val, sidebar_id = 321 } = req.body;
  // console.log("req.body: ", req.body);
  if (req.files) {
    // const doc = req.files.document;
    // req.body.document = await uploadFile("ohs_file_assessment", doc);
    const file = req.files.document;
    const ddrm_id = await processesSingleDDRMDocument(
      "ohs_file_assessment",
      sidebar_id,
      file,
      req
    );
    req.body.ddrm_id = ddrm_id;
  }
  val = JSON.parse(val);
  let ohs_requirement = val.ohs_requirements;

  if (ohs_requirement) {
    const [fetchOrg] = await db.query(
      `SELECT * FROM ohs_file_requirement WHERE id = ${ohs_requirement}`
    );
    req.body.organization = fetchOrg[0]?.organization;
    req.body.department = fetchOrg[0]?.department;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  // if (id) {
  //   await deleteRecord(OhsFileDocs, id, "ohs_id");
  // }
  // let document = [];
  // for (let i = 0; i <= 71; i++) {
  //   if (req.files[`document${i}`] || req.body[`document${i}`]) {
  //     const file = req.files[`document${i}`];
  //     if (typeof file != "string" && typeof file == "object") {
  //       const filePath = await uploadFile("ohs_file_assessment", file);
  //       document.push({ file: filePath, doc_no: i });
  //     } else {
  //       document.push({ file: req.body[`document${i}`], doc_no: i });
  //     }
  //   }
  // }

  const documents = await processUploadDocuments(req, sidebar_id, "document");

  if (id && documents.length) {
    const deleteQuery = `UPDATE ohs_file_docs SET deleted = 1 where deleted = 0 AND ohs_id = ?`;
    await db.query(deleteQuery, [id]);
  }
  req.body.ohs_requirement = ohs_requirement;
  req.body.vals = val;
  req.body = await encodeAndStringifyFields(req.body);

  if (!id) {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      req.body.department,
      "OhsFileAssessment",
      "ohs_file_assessment",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  // Update status in "ohe_file_assessment" as per "OHS FILE ASSESSMENT CHECKLIST" form
  if(val.status == 1) {
    req.body.status = "Approved"
  } else {
    req.body.status = "Pending"
  }

  const { query, values } = id
    ? updateQueryBuilder(OhsFileAssessment, req.body)
    : createQueryBuilder(OhsFileAssessment, req.body);
  const [result] = await db.query(query, values);

  if (documents || Array.isArray(documents)) {
    // Iterate through uploaded files
    for (const file of documents) {
      const ddrm_id = file?.ddrm_id;
      const id_doc = file.id;
      // Move the file to the public folder
      // Save file details for database
      const { query: docQuery, values: docValues } = createQueryBuilder(
        OhsFileDocs,
        {
          doc_no: id_doc,
          ohs_id: id ? id : result.insertId,
          ddrm_id,
        }
      );

      await db.query(docQuery, docValues);
    }
  }
  // for (let doc of document) {
  //   const { query, values } = createQueryBuilder(OhsFileDocs, {
  //     ...doc,
  //     ohs_id: id ? id : result.insertId,
  //   });
  //   await db.query(query, values);
  // }

  await insertActivityLog(
    req.user.sessionid,
    status,
    "Contractor Agreements",
    id ? id : result.insertId
  );

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getOhsFileAssessment = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "ohs_file_assessment",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = ["CONCAT(users.name , ' ' , users.surname)", 
    "ohs_file_assessment.unique_id", 
    "ohs_file_requirement.title",
    "contractor_registration.contractor_name",
    "ohs_file_requirement.company_registration_no",
    "organization.name"
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = ohs_file_assessment.created_by",
    },
    {
      type: "left",
      targetTable: "ohs_file_requirement",
      onCondition:
        "ohs_file_requirement.id = ohs_file_assessment.ohs_requirement",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition:
        "contractor_registration.id = ohs_file_requirement.contractor",
    },
    {
      type: "left",
      targetTable: "repository",
      onCondition: "repository.id = ohs_file_assessment.ddrm_id",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = ohs_file_assessment.organization",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const ohsFileRequirementQuery = `SELECT ohs_file_assessment.* , ohs_file_requirement.company_registration_no,
  ohs_file_requirement.title,
  ohs_file_requirement.coida_registration_no,
  ohs_file_requirement.contact_person,
  ohs_file_requirement.contact_number,
  ohs_file_requirement.site_address,
  ohs_file_requirement.postal_address,
  ohs_file_requirement.section_appointment,
  ohs_file_requirement.health_safety_representative,
  ohs_file_requirement.activities_rendered,
  ohs_file_requirement.commencement_date,
  ohs_file_requirement.completion_date,
  ohs_file_requirement.employees_on_site,
  ohs_file_requirement.female,
  ohs_file_requirement.male,
  ohs_file_requirement.people_with_disabilities, ohs_file_requirement.contractor, contractor_registration.contractor_name AS contractor_name, CONCAT(users.name , ' ' , users.surname) AS created_by_name,repository.url as document, organization.name as organization_name FROM ohs_file_assessment ${joinCondition} WHERE ohs_file_assessment.deleted = 0 ${searchCondition} ${condition}`;

  let [ohsFileRequirement] = await db.query(ohsFileRequirementQuery);
  // console.log(ohsFileRequirement);
  ohsFileRequirement = await decodeAndParseFields(ohsFileRequirement);
  // console.log(ohsFileRequirement);
  ohsFileRequirement = await decodeAndParseFields(ohsFileRequirement);

  for (let doc of ohsFileRequirement) {
    const [files] = await db.query(
      `SELECT ohs_file_docs.*, repository.url as file, document_creation.document_name as title FROM ohs_file_docs LEFT JOIN repository ON repository.id = ohs_file_docs.ddrm_id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE ohs_file_docs.deleted = 0 AND ohs_id = ${doc.id}`
    );

    doc.images = files;
  }

  const totalRecord = await countQueryCondition(ohsFileRequirementQuery);

  return sendResponse(res, 200, ohsFileRequirement, totalRecord);
};

export const deleteOhsFileAssessment = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(OhsFileAssessment, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Contractor Agreements",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};
