import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  createQueryBuilder,
  updateQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import SecurityIncidentType from "../sequelize/SecurityIncidentTypeSchema.js";

/** Function to create or update SecurityIncidentType */
export const createUpdateSecurityIncidentType = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "SIT",
      "security_incident_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(SecurityIncidentType, req.body)
    : createQueryBuilder(SecurityIncidentType, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "SecurityIncidentType", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/** Function to view all or single SecurityIncidentType */
export const viewSecurityIncidentType = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "security_incident_type");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "security_incident_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = [
    "security_incident_type.name",
    "security_incident_type.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = security_incident_type.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = security_incident_type.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT security_incident_type.*, CONCAT(users.name, ' ', users.surname) AS created_by, security_incident_type.organization AS organizations FROM security_incident_type ${joinsRecord} WHERE security_incident_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //     if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM security_incident_type WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete SecurityIncidentType */
export const deleteSecurityIncidentType = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("security_incident_type", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "SecurityIncidentType", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
