import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  deleteSettingRecord,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  decodeAndParseFields,
  getRecord,
} from "../helper/general.js";
import TrainingDisclaimer from "../sequelize/TrainingDisclaimerSchema.js";

/** Function to create or update TrainingDisclaimer */
export const createUpdateTrainingDisclaimer = async (req, res) => {
  const { id } = req.body;
  // this will be one record in database
  if (!id) {
    // this will be one record in database
    const [recordExist] = await getRecord(
      "training_disclaimer",
      "deleted",
      "0"
    );
    if (recordExist) {
      return sendResponse(res, 400, "Record already exist");
    }
  }
  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(TrainingDisclaimer, req.body)
    : createQueryBuilder(TrainingDisclaimer, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(
    req.user.sessionid,
    status,
    "TrainingDisclaimer",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/** Function to view all or single TrainingDisclaimer */
export const viewTrainingDisclaimer = async (req, res) => {
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "training_disclaimer.name",
    "training_disclaimer.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = training_disclaimer.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let trainingDisclaimerQuery = `SELECT 
  training_disclaimer.*, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM training_disclaimer
${joinsRecord} 
WHERE training_disclaimer.deleted = 0 ${searchCondition}`;
  let [trainingDisclaimer] = await db.query(trainingDisclaimerQuery);
  trainingDisclaimer = await decodeAndParseFields(trainingDisclaimer);
  return sendResponse(res, 200, trainingDisclaimer);
};

/** Function to delete TrainingDisclaimer */
export const deleteTrainingDisclaimer = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("training_disclaimer", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "TrainingDisclaimer",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
