import { verifyToken } from "./tokenVerify.js";
import axios from "axios";
import dotenv from "dotenv";

dotenv.config();

export function base64urlDecode(str) {
  // Replace URL-safe characters with standard Base64 characters
  let base64 = str
    .replace(/-/g, "+") // Replace '-' with '+'
    .replace(/_/g, "/") // Replace '_' with '/'
    .replace(/\s+/g, ""); // Remove any spaces

  // Add padding if necessary (Base64 requires length to be a multiple of 4)
  const padding =
    base64.length % 4 === 0 ? "" : "=".repeat(4 - (base64.length % 4));

  // Decode from Base64
  return Buffer.from(base64 + padding, "base64").toString("utf8");
}

export function decodeJWT(jwt) {
  // Split the JWT into its three parts (header, payload, and signature)
  const parts = jwt.split(".");

  if (parts.length !== 3) {
    throw new Error("Invalid JWT format");
  }

  // Decode the header and payload using base64url
  const header = JSON.parse(base64urlDecode(parts[0]));
  const payload = JSON.parse(base64urlDecode(parts[1]));

  return {
    header,
    payload,
  };
}

export const decodeSuperAdminToken = async (req, res, next) => {
  try {
    const authHeader = req.headers["authorization"];
    const token = authHeader && authHeader.split(" ")[1];
    let deploymentUrl = process.env.DEPLOYMENT_URL;

    if (token == null) {
      return res.status(401).json({
        status: false,
        message: "Token is required",
      });
    }
    const decodedData = decodeJWT(token);
    const payload = decodedData.payload;
    console.log("Decoded payload:", payload);

    if (!payload["isDeploymentManager"]) {
      return verifyToken(req, res, next);
    }

    // AXIOS
    const response = await axios.get(
      `${deploymentUrl}/api/auth/validate-token`,
      {
        headers: {
          Authorization: ` Bearer ${token}`,
        },
      }
    );

    if (response) {
      console.log("success");
    } else {
      return res.status(500).json({ status: false, message: "Unauthorized" });
    }

    // res;
  } catch (error) {
    console.error(error.message);
  }
};
