// use it in the new Controllers

import chalk from "chalk";
import { storeError } from "./general.js";

export const controllerWrapper = (controller) => {
  return async (req, res, next) => {
    try {
      await controller(req, res, next);
    } catch (error) {
      console.log(chalk.red("IP: of Imposter is : ", req.ip));
      storeError(error);
      return res.status(500).json({
        status: false,
        message: error.message,
      });
    }
  };
};

export const sendResponse = (res, statusCode, message, message2 = null) => {
  let status = false;
  if (statusCode >= 200 && statusCode <= 299) status = true;
  const obj = {};
  obj.status = status;
  if (typeof message == "string") {
    obj.message = message;
  } else {
    obj.data = message;
  }
  if (message2 !== null) {
    if (Array.isArray(message2)) obj.errorMessage = message2;
    else if (typeof message2 == "string") obj.message = message2;
    else obj.total = message2;
  }
  return res.status(statusCode).json(obj);
};

export class ApiResponse {
  constructor(statusCode, data, message = "Success") {
    this.statusCode = statusCode;
    this.data = data;
    this.message = message;
    this.success = statusCode < 400;
  }
}
