import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
// import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateAnnouncement, deleteAnnouncement, viewAllAnnouncement } from "../controller/announcementController.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";

/**
 * @swagger 
 * tags:
 *   name: Announcement
 *   description: API operations for managing announcements
 */
const announcementRoutes = Router();

/**
 * @swagger
 * /api/announcement/create-update-announcement:
 *   post:
 *     summary: Create or update an announcement
 *     tags: [Announcement]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example:
 *             announcement_id: 1
 *             title: "title"
 *             description: "description"
 */
announcementRoutes.post(
  "/create-update-announcement",
  verifyToken,
  // sideBarPermissionCheck("create", 372, "audit_scheduling"),
  controllerWrapper(createUpdateAnnouncement))

/**
 * @swagger
 * /api/announcement/create-update-announcement:
 *   put:
 *     summary: Update an announcement
 *     tags: [Announcement]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example:
 *             announcement_id: 1
 *             title: "title"
 *             description: "description"
 */
announcementRoutes.put(
  "/create-update-announcement",
  verifyToken,
  // sideBarPermissionCheck("edit", 372, "audit_scheduling"),
  controllerWrapper(createUpdateAnnouncement))

/**
 * @swagger
 * /api/announcement/get-all-announcement:
 *   get:
 *     summary: Get all announcements
 *     tags: [Announcement]
 *     parameters:
 */
announcementRoutes.get(
    "/get-all-announcement",
    verifyToken,
    // sideBarPermissionCheck("view", 372, "audit_scheduling"),
    controllerWrapper(viewAllAnnouncement)
)

/**
 * @swagger
 * /api/announcement/get-announcement/{id}:
 *   get:
 *     summary: Get an announcement by ID
 *     tags: [Announcement]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: ID of the announcement to retrieve
 */
announcementRoutes.get(
    "/get-announcement",
    verifyToken,
    // sideBarPermissionCheck("view", 372, "audit_scheduling"),
    controllerWrapper(viewAllAnnouncement)
)

/**
 * @swagger
 * /api/announcement/delete-announcement/{id}:
 *   delete:
 *     summary: Delete an announcement by ID
 *     tags: [Announcement]
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         schema:
 *           type: string
 *         description: ID of the announcement to delete
 */
announcementRoutes.delete(
    "/delete-announcement/:id",
    verifyToken,
    // sideBarPermissionCheck("delete", 372, "audit_scheduling"),
    controllerWrapper(deleteAnnouncement)
)


export default announcementRoutes;