import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCommunicationMethod, deleteCommunicationMethod, viewCommunicationMethod } from "../controller/communicationMethodController.js";

/**
 * @swagger
 * tags:
 *   name:  communication method
 *   description: API operations for managing  communication method
 */
const communicationMethodRoutes = Router();

/**
 * @swagger
 * /api/communicationMethod/create-update-communication-method:
 *   post:
 *     summary: Create or update a  communication method
 *     tags: [ communication method]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
communicationMethodRoutes.post(
  "/create-update-communication-method",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 449 , "communication_method")(req, res, next);
  },
  controllerWrapper(createUpdateCommunicationMethod)
);

/**
 * @swagger
 * /api/communicationMethod/get-communication-method:
 *   get:
 *     summary: Get all records of  communication method
 *     tags: [ communication method]
 */
communicationMethodRoutes.get(
  "/get-communication-method",
  verifyToken,
  sideBarPermissionCheck("view", 449, "communication_method"),
  controllerWrapper(viewCommunicationMethod)
);

/**
 * @swagger
 * /api/communicationMethod/get-communication-method/{id}:
 *   get:
 *     summary: Get a specific record of  communication method
 *     tags: [ communication method]
 */
communicationMethodRoutes.get(
  "/get-communication-method/:id",
  verifyToken,
  sideBarPermissionCheck("view", 449, "communication_method"),
  controllerWrapper(viewCommunicationMethod)
);

/**
 * @swagger
 * /api/communicationMethod/delete-communication-method/{id}:
 *   delete:
 *     summary: Delete a specific record of  communication method
 *     tags: [ communication method]
 */
communicationMethodRoutes.delete(
  "/delete-communication-method/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 449, "communication_method"),
  controllerWrapper(deleteCommunicationMethod)
);

export default communicationMethodRoutes;