import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import {
  auditManagementDashboardData,
  getActionDashboardData,
  getLeadershipDashBoardData,
  getMeetingDashboardData,
  getObjectiveTargetDashboardData,
  hseAppointmentDashboardData,
  incidentDashboardData,
  ncrStopCertificateDashboardData,
  policyStatusAnalysisReportData,
  riskManagementDashboardData,
} from "../controller/dashboardController.js";

/**
 * @swagger
 * tags:
 *   name: Dashboard
 *   description: Endpoints related to dashboard data
 *
 *
 */

const dashboardRoutes = Router();

/**
 * @swagger
 * /api/dashboard/get-dashboard-risk-management-data:
 *   get:
 *     summary: Get risk management data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved risk management dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */

dashboardRoutes.get("/get-dashboard-risk-management-data", verifyToken, controllerWrapper(riskManagementDashboardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-policy-management-data:
 *   get:
 *     summary: Get policy management data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved policy management dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */

dashboardRoutes.get(
  "/get-dashboard-policy-management-data",
  verifyToken,
  controllerWrapper(policyStatusAnalysisReportData)
);

/**
 * @swagger
 * /api/dashboard/get-dashboard-employee-data:
 *   get:
 *     summary: Get employee data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved employee dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-leadership-data", verifyToken, controllerWrapper(getLeadershipDashBoardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-objective-target-data:
 *   get:
 *     summary: Get objective target data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved objective target dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get(
  "/get-dashboard-objective-target-data",
  verifyToken,
  controllerWrapper(getObjectiveTargetDashboardData)
);

/**
 * @swagger
 * /api/dashboard/get-dashboard-audit-management-data:
 *   get:
 *     summary: Get audit management data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved audit management dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get(
  "/get-dashboard-audit-management-data",
  verifyToken,
  controllerWrapper(auditManagementDashboardData)
);

/**
 * @swagger
 * /api/dashboard/get-dashboard-hse-appointment-data:
 *   get:
 *     summary: Get HSE appointment data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved HSE appointment dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-hse-appointment-data", verifyToken, controllerWrapper(hseAppointmentDashboardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-ncr-stop-certificate-data:
 *   get:
 *     summary: Get NCR stop certificate data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved NCR stop certificate dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-ncr-stop-certificate-data", verifyToken, controllerWrapper(ncrStopCertificateDashboardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-incident-data:
 *   get:
 *     summary: Get incident data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved incident dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-incident-data", verifyToken, controllerWrapper(incidentDashboardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-action-data:
 *   get:
 *     summary: Get action data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved action dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-action-data",  verifyToken, controllerWrapper(getActionDashboardData));

/**
 * @swagger
 * /api/dashboard/get-dashboard-meeting-data:
 *   get:
 *     summary: Get action data for the dashboard
 *     tags: [Dashboard]
 *     security:
 *       - BearerAuth: []
 *     responses:
 *       200:
 *         description: Successfully retrieved action dashboard data
 *       403:
 *         description: Unauthorized access
 *       500:
 *         description: Internal server error
 */
dashboardRoutes.get("/get-dashboard-meeting-data", verifyToken, controllerWrapper(getMeetingDashboardData));

export default dashboardRoutes;
