import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateDefectType, deleteDefectType, viewDefectType } from "../controller/defectTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  defect type
 *   description: API operations for managing  defect type
 */
const defectTypeRoutes = Router();

/**
 * @swagger
 * /api/defectType/create-update-defect-type:
 *   post:
 *     summary: Create or update a  defect type
 *     tags: [ defect type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
defectTypeRoutes.post(
  "/create-update-defect-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 414 , "defect_type")(req, res, next);
  },
  controllerWrapper(createUpdateDefectType)
);

/**
 * @swagger
 * /api/defectType/get-defect-type:
 *   get:
 *     summary: Get all records of  defect type
 *     tags: [ defect type]
 */
defectTypeRoutes.get(
  "/get-defect-type",
  verifyToken,
  sideBarPermissionCheck("view", 414, "defect_type"),
  controllerWrapper(viewDefectType)
);

/**
 * @swagger
 * /api/defectType/get-defect-type/{id}:
 *   get:
 *     summary: Get a specific record of  defect type
 *     tags: [ defect type]
 */
defectTypeRoutes.get(
  "/get-defect-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 414, "defect_type"),
  controllerWrapper(viewDefectType)
);

/**
 * @swagger
 * /api/defectType/delete-defect-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  defect type
 *     tags: [ defect type]
 */
defectTypeRoutes.delete(
  "/delete-defect-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 414, "defect_type"),
  controllerWrapper(deleteDefectType)
);

export default defectTypeRoutes;