import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateDeviationCategory, deleteDeviationCategory, viewDeviationCategory } from "../controller/deviationCategoryController.js";

/**
 * @swagger
 * tags:
 *   name:  deviation category
 *   description: API operations for managing  deviation category
 */
const deviationCategoryRoutes = Router();

/**
 * @swagger
 * /api/deviationCategory/create-update-deviation-category:
 *   post:
 *     summary: Create or update a  deviation category
 *     tags: [ deviation category]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
deviationCategoryRoutes.post(
  "/create-update-deviation-category",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 419, "deviation_category")(req, res, next);
  },
  controllerWrapper(createUpdateDeviationCategory)
);

/**
 * @swagger
 * /api/deviationCategory/get-deviation-category:
 *   get:
 *     summary: Get all records of  deviation category
 *     tags: [ deviation category]
 */
deviationCategoryRoutes.get(
  "/get-deviation-category",
  verifyToken,
  sideBarPermissionCheck("view", 419, "deviation_category"),
  controllerWrapper(viewDeviationCategory)
);

/**
 * @swagger
 * /api/deviationCategory/get-deviation-category/{id}:
 *   get:
 *     summary: Get a specific record of  deviation category
 *     tags: [ deviation category]
 */
deviationCategoryRoutes.get(
  "/get-deviation-category/:id",
  verifyToken,
  sideBarPermissionCheck("view", 419, "deviation_category"),
  controllerWrapper(viewDeviationCategory)
);

/**
 * @swagger
 * /api/deviationCategory/delete-deviation-category/{id}:
 *   delete:
 *     summary: Delete a specific record of  deviation category
 *     tags: [ deviation category]
 */
deviationCategoryRoutes.delete(
  "/delete-deviation-category/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 419, "deviation_category"),
  controllerWrapper(deleteDeviationCategory)
);

export default deviationCategoryRoutes;