import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateDocumentClassification, deleteDocumentClassification, viewDocumentClassification } from "../controller/documentClassificationController.js";
/**
 * @swagger
 * tags:
 *   name:  document classification
 *   description: API operations for managing  document classification
 */
const documentClassificationRoutes = Router();

/**
 * @swagger
 * /api/documentClassification/create-update-document-classification:
 *   post:
 *     summary: Create or update a  document classification
 *     tags: [ document classification]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
documentClassificationRoutes.post(
  "/create-update-document-classification",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 377 , "document_classification")(req, res, next);
  },
  controllerWrapper(createUpdateDocumentClassification)
);

/**
 * @swagger
 * /api/documentClassification/get-document-classification:
 *   get:
 *     summary: Get all records of  document classification
 *     tags: [ document classification]
 */
documentClassificationRoutes.get(
  "/get-document-classification",
  verifyToken,
  sideBarPermissionCheck("view", 377, "document_classification"),
  controllerWrapper(viewDocumentClassification)
);

/**
 * @swagger
 * /api/documentClassification/get-document-classification/{id}:
 *   get:
 *     summary: Get a specific record of  document classification
 *     tags: [ document classification]
 */
documentClassificationRoutes.get(
  "/get-document-classification/:id",
  verifyToken,
  sideBarPermissionCheck("view", 377, "document_classification"),
  controllerWrapper(viewDocumentClassification)
);

/**
 * @swagger
 * /api/documentClassification/delete-document-classification/{id}:
 *   delete:
 *     summary: Delete a specific record of  document classification
 *     tags: [ document classification]
 */
documentClassificationRoutes.delete(
  "/delete-document-classification/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 377, "document_classification"),
  controllerWrapper(deleteDocumentClassification)
);

export default documentClassificationRoutes;