import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateTrainingDisclaimer,
  deleteTrainingDisclaimer,
  viewTrainingDisclaimer,
} from "../controller/trainingDisclaimerController.js";

/**
 * @swagger
 * tags:
 *   name:  training disclaimer
 *   description: API operations for managing  training disclaimer
 */
const trainingDisclaimerRoutes = Router();

/**
 * @swagger
 * /api/trainingDisclaimer/create-update-training-disclaimer:
 *   post:
 *     summary: Create or update a  training disclaimer
 *     tags: [ training disclaimer]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
trainingDisclaimerRoutes.post(
  "/create-update-training-disclaimer",
  verifyToken,
  // (req, res, next) => {
  //   sideBarPermissionCheck(req.body.id ? "edit" : "create", 458 , "training_disclaimer")(req, res, next);
  // },
  controllerWrapper(createUpdateTrainingDisclaimer)
);

/**
 * @swagger
 * /api/trainingDisclaimer/get-training-disclaimer:
 *   get:
 *     summary: Get all records of  training disclaimer
 *     tags: [ training disclaimer]
 */
trainingDisclaimerRoutes.get(
  "/get-training-disclaimer",
  verifyToken,
  // sideBarPermissionCheck("view", 458, "training_disclaimer"),
  controllerWrapper(viewTrainingDisclaimer)
);

/**
 * @swagger
 * /api/trainingDisclaimer/get-training-disclaimer/{id}:
 *   get:
 *     summary: Get a specific record of  training disclaimer
 *     tags: [ training disclaimer]
 */
trainingDisclaimerRoutes.get(
  "/get-training-disclaimer/:id",
  verifyToken,
  // sideBarPermissionCheck("view", 458, "training_disclaimer"),
  controllerWrapper(viewTrainingDisclaimer)
);

/**
 * @swagger
 * /api/trainingDisclaimer/delete-training-disclaimer/{id}:
 *   delete:
 *     summary: Delete a specific record of  training disclaimer
 *     tags: [ training disclaimer]
 */
trainingDisclaimerRoutes.delete(
  "/delete-training-disclaimer/:id",
  verifyToken,
  // sideBarPermissionCheck("delete", 458, "training_disclaimer"),
  controllerWrapper(deleteTrainingDisclaimer)
);

export default trainingDisclaimerRoutes;
