import { EndFields } from "../constants/constants.js";
import sequelize from "./sequelize.js";
import { DataTypes, Model } from "sequelize";
import WorkArea from "./WorkAreaSchema.js";
import OperationalRisk from "./OperationalRiskSchema.js";

class Activities extends Model {}

Activities.init(
  {
    name: {
      type: DataTypes.STRING(250),
    },
    frequency: {
      type: DataTypes.STRING(250),
    },
    work_id: {
      type: DataTypes.INTEGER,
      references: {
        model: WorkArea,
        key: WorkArea.primaryKeyAttribute,
      },
    },
    operational_risk_id: {
      type: DataTypes.INTEGER,
      references: {
        model: OperationalRisk,
        key: OperationalRisk.primaryKeyAttribute,
      },
    },
    ...EndFields,
  },
  {
    tableName: "operational_activities",
    sequelize,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await Activities.sync({ alter: true }));
export default Activities;
