import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";

const ActivityLog = sequelize.define(
  "ActivityLog",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    status: {
      type: DataTypes.ENUM(
        "login",
        "logout",
        "create",
        "update",
        "delete",
        "view",
        "visit",
        "others",
        "approved",
        "reject",
        //extra
        "created",
        "updated",
        "deleted",
        "assigned",
        "comment"
      ),
      allowNull: true,
      comment: "This is work status for activity log that what happened at that time",
    },
    module: {
      type: DataTypes.STRING(500),
      allowNull: true,
      comment: "Store all work id where changes happen",
    },
    message: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "activity_log",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// ActivityLog.belongsTo(User, { as: "creator", foreignKey: "created_by" });
// console.log(await ActivityLog.sync({ alter: true }));

export default ActivityLog;
