import ContractorRegistration from "./ContractorRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const ContractorIncident = sequelize.define(
  "ContractorIncident",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    incident_report_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_incident: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_incident_reporting: {
      type: DataTypes.TIME(6),
      allowNull: true,
    },
    time_of_incident_occurrence: {
      type: DataTypes.TIME(6),
      allowNull: true,
    },
    initial_incident_severity: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    location: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    is_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // "photographs_incident": [
    //     {
    //         "id": "",
    //         "title": "hello1",
    //         "file": {}
    //     },
    //     {
    //         "id": "",
    //         "title": "hello2",
    //         "file": {},
    //         "oldData": ""
    //     }
    // ],
    save_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    current_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    potential_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    person_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    internal_persons: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    incident_reporting_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_incident",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorIncident.belongsTo(User, {
  foreignKey: "incident_reporting_by",
  as: "Reporter",
});
ContractorIncident.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorIncident.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorIncident.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});

export default ContractorIncident;
