import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ContractorMeeting from "./ContractorMeetingSchema.js";
import ContractorMeetingRecording from "./ContractorMeetingRecordingSchema.js";
import User from "./UserSchema.js";

const ContractorMeetingNotes = sequelize.define(
  "ContractorMeetingNotes",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    meeting_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    meeting_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorMeetingRecording,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    agenda_item: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    meeting_discussion_name: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    meeting_discussion: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    action_discussion_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    meeting_action_items: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    meeting_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assigned_to: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    raised_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    completed_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notes_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    meeting_action_progress: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "contractor_meeting_notes",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations for ContractorMeetingNotes
ContractorMeetingNotes.belongsTo(ContractorMeetingRecording, {
  foreignKey: "meeting_recording_id",
  as: "meetingRecording",
});

ContractorMeetingNotes.belongsTo(User, {
  foreignKey: "raised_by",
  as: "raisedByUser",
});

ContractorMeetingNotes.belongsTo(User, {
  foreignKey: "created_by",
  as: "creator",
});

ContractorMeetingNotes.belongsTo(User, {
  foreignKey: "updated_by",
  as: "updater",
});

export default ContractorMeetingNotes;
