import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import IssuingAuthority from "./IssuingAuthoritySchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import PermitLicense from "./PermitLicenseSchema.js";

const ContractorPermitLicense = sequelize.define(
  "ContractorPermitLicense",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: PermitLicense,
        key: "id",
      },
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    permit_holder: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    permit_license_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    permit_type: {
      type: DataTypes.STRING(255), //removed
      allowNull: true,
    },
    issuing_authority: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IssuingAuthority,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    permit_license_id: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    applicable_section_of_legislation: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    issue_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    employee: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    permit_license_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    condition_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "contractor_permit_license",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorPermitLicense.belongsTo(IssuingAuthority, {
  foreignKey: "issuing_authority",
  as: "IssuingAuthority",
});

ContractorPermitLicense.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

ContractorPermitLicense.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

ContractorPermitLicense.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});

ContractorPermitLicense.belongsTo(ProjectRegistration, {
  foreignKey: "project",
  as: "Project",
});

// console.log(await ContractorPermitLicense.sync({ alter: true }));

export default ContractorPermitLicense;

// {
//   "organization": 14,
//   "contractor": 55,
//   "project": 35,
//   "cipc_registration_number": 1234,   //get from contractor
//   "permit_license_category": "Environmental",   // new field
//   "description": "<p>&nbsp;Authorizes the operation of industrial facilities in compliance with environmental regulations</p>",
//   "permit_license_number": "23333",
//   "issuing_authority": 128,
//   "applicable_section_of_legislation": "<p><span style=\"color: rgba(255, 255, 255, 0.7);\">Applicable Section of Legislation</span></p>",
//   "issue_date": "2025-01-02",
//   "effective_date": "2025-01-15",  // new field
//   "end_date": "2025-01-24",       //new field
//   "permit_holder": "personal",
//   "employee": 163,              // new field
//   "employee_name": "John Doe",   // for get only
//   "role_name": "assistant",      // for get only
//   "employee_department": "Department Name343343434",  // for get only
//   "employee_number": "H&HG/2425/006",   // for get only
//   "condition_description": [
//       {
//           "description": "<p><span style=\"color: rgba(255, 255, 255, 0.7);\">permit and License Condition Description 1</span></p>"
//       }
//   ],
//   "permit_and_license_description": "<p><span style=\"color: rgba(255, 255, 255, 0.7);\">Permit and License Description</span></p>",
//   "title": 404,
//    "permit_license_name" : "Permit Name"
// }
