import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Banks from "./BanksSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const ContractorRegistration = sequelize.define(
  "ContractorRegistration",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    phone_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    physical_address: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    cipc_registration_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tax_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    bbbee_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    vat_registered: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "No",
    },
    vat_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    bank: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Banks,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    account_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    bank_code: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    account_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    payment_terms: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    work_service_provided: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_work: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // start_date: {
    //   type: DataTypes.DATEONLY,
    //   allowNull: true,
    // },
    // end_date: {
    //   type: DataTypes.DATEONLY,
    //   allowNull: true,
    // },
    // contract_value: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // currency: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // allocation_human_resource: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    classification_value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    classification_criticality: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    classification_impact: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    classification_category: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    contractor_employees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    emergency_contacts: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    contractor_owner: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // other_information: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // proof_of_insurance: {
    //   type: DataTypes.TEXT('long'),
    //   allowNull: true,
    // },
    // relevant_certifications: {
    //   type: DataTypes.TEXT('long'),
    //   allowNull: true,
    // },
    // emergency_contact_name: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_number: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_designation: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_value: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_criticality: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_impact: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // emergency_contact_work_category: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "contractor_registration",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorRegistration.belongsTo(Banks, { foreignKey: "bank", as: "Bank" });
ContractorRegistration.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorRegistration.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorRegistration.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorRegistration.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await ContractorRegistration.sync({ alter: true }));

export default ContractorRegistration;
