import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const ContractorRiskRegister = sequelize.define(
  "ContractorRiskRegister",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    risk_register_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    assessment_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    risk_assessment_facilitator: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // status: {
    //   type: DataTypes.ENUM("Pending Approval", "Approved", "Rejected"),
    //   allowNull: true,
    //   defaultValue: "Pending Approval",
    // },
    // reject_comment: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_risk_register",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorRiskRegister.belongsTo(User, {
  foreignKey: "risk_assessment_facilitator",
  as: "RiskAssessmentFacilitator",
});
ContractorRiskRegister.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorRiskRegister.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorRiskRegister.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorRiskRegister.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default ContractorRiskRegister;
