import ContractorSiteAccess from "./ContractorSiteAccessSchema.js";
import Repository from "./RepositorySchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const ContractorSiteAccessDocs = sequelize.define(
  "ContractorSiteAccessDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    contractor_site_access_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorSiteAccess,
        key: "id",
      },
      onDelete: "SET NULL",
      onUpdate: "CASCADE",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,

    tableName: "contractor_site_access_docs",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await ContractorSiteAccessDocs.sync({ alter: true }));

export default ContractorSiteAccessDocs;
