import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorTrainingSchedule from "./ContractorTrainingScheduleSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorTrainingAttendance = sequelize.define(
  "ContractorTrainingAttendance",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractors: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    projects: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    actual_training_service: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    attendees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employee: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    group_name: {
      type: DataTypes.STRING(255),
    },
    role_name: {
      type: DataTypes.STRING(255),
    },
    provider_department: {
      type: DataTypes.STRING(255),
    },
    training_actual_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    training_program: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorTrainingSchedule,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    training_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    training_total_cost: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    training_venue: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    // upload_document: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // ddrm_id:{
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references:{
    //     model: Repository,
    //     key: "id"
    //   }
    // },
    currency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "contractor_attendance_recording",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorTrainingAttendance.belongsTo(ContractorTrainingSchedule, {
  foreignKey: "training_program",
  as: "TrainingProgram",
});
ContractorTrainingAttendance.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorTrainingAttendance.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorTrainingAttendance.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ContractorTrainingAttendance.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await ContractorTrainingAttendance.sync({ alter: true }));
export default ContractorTrainingAttendance;
