import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary

const Country = sequelize.define(
  "Country",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    iso3: {
      type: DataTypes.CHAR(3),
      allowNull: true,
    },
    numeric_code: {
      type: DataTypes.CHAR(3),
      allowNull: true,
    },
    iso2: {
      type: DataTypes.CHAR(2),
      allowNull: true,
    },
    phonecode: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    capital: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    currency: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    currency_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    currency_symbol: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tld: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    native: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    region: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    region_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    subregion: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    subregion_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    nationality: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    timezones: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    translations: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    latitude: {
      type: DataTypes.DECIMAL(10, 8),
      allowNull: true,
    },
    longitude: {
      type: DataTypes.DECIMAL(11, 8),
      allowNull: true,
    },
    emoji: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    emojiU: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    flag: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    wikiDataId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      comment: "Rapid API GeoDB Cities",
    },
  },
  {
    tableName: "country",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_unicode_ci",
  }
);
// console.log(await Country.sync({ alter: true }));
export default Country;
