import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";

const DocumentCreation = sequelize.define(
  "document_creation",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    document_amendment: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    select_revised_document: {
      type: DataTypes.STRING,
      allowNull: true,
      //references: from document_creation itself
    },

    document_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Unique document identifier
    unique_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    repository_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    sidebar_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },

    // Type of document (document, policy, etc.)
    document_type: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Description of the document
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    upload_document: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    // Version number of the document
    version_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    // Owner of the document
    document_owner: {
      type: DataTypes.ENUM("Internal", "External"),
      allowNull: false,
      defaultValue: "Internal",
    },
    owner_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "users",
        key: "id",
      },
    },
    specify_owner: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    specify_owner_email: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    document_origin: {
      type: DataTypes.ENUM("Internal", "External"),
      allowNull: false,
      defaultValue: "Internal",
    },
    // Hierarchy or category of the document
    document_hierarchy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    // Classification of the document ('Confidential' , 'Private' , 'Restricted' , 'Unclassified')
    document_classification: {
      type: DataTypes.ENUM("Confidential", "Private", "Restricted", "Unclassified"),
      allowNull: false,
      defaultValue: "Private",
    },
    // Tags associated with the document
    document_tags: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    // Employees with viewing rights
    viewing_rights_employees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    // Employees with modification rights
    modification_rights_employees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    // Employees with deleting rights
    deleting_rights_employees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    // Effective date of the document
    effective_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },

    // Expiry date of the document
    expiry_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },

    // Keywords for the document
    document_keywords: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    employee_reviewer: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    // Employee name who reviewed the document
    reviewer_employee_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    is_archived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },

    // Reviewer role
    reviewer_role: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Department of the reviewer
    reviewer_department: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Employee name who approved the document
    approver_employee_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    is_locked: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },

    // Approver role
    approver_role: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Department of the approver
    approver_department: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    // Current status of the document (In-Review, Approved, etc.)
    document_status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("accept", "reject", "pending"),
      allowNull: true,
      defaultValue: "pending",
    },
    // Storage location of the document
    document_storage_location: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "document_creation",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await DocumentCreation.sync({ alter: true }));

export default DocumentCreation;