import Organization from "./OrganizationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Department from "./DepartmentSchema.js";

const IncidentCategory = sequelize.define(
  "IncidentCategory",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      // references: {
      //   model: Organization,
      //   key: "id",
      // },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    is_static: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "incident_category",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// IncidentCategory.belongsTo(Organization, {
//   foreignKey: "organization",
//   as: "Organization",
// });
IncidentCategory.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
IncidentCategory.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
IncidentCategory.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await IncidentCategory.sync({ alter: true }));
export default IncidentCategory;
