import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js"; // Adjust imports according to your project
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import { EndFields } from "../constants/constants.js";

// Define the InspectionLocation model
const InspectionLocation = sequelize.define(
  "inspection_location",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    type: {
      type: DataTypes.STRING(255),
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "inspection_location",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
InspectionLocation.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
InspectionLocation.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});
InspectionLocation.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
InspectionLocation.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});
// console.log(await InspectionLocation.sync({ alter: true }));
export default InspectionLocation;
