import { Model, DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import User from "./UserSchema.js";
import IncidentCategory from "./IncidentCategorySchema.js";
import { EndFields } from "../constants/constants.js";

class Investigation extends Model {}

Investigation.init(
  {
    incident_id: {
      type: DataTypes.INTEGER,
      references: {
        model: Incident,
        key: Incident.primaryKeyAttribute,
      },
    },
    is_done: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    reference_no: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    incident_name: {
      type: DataTypes.STRING(255),
    },
    incident_date: {
      type: DataTypes.DATEONLY,
    },
    incident_time: {
      type: DataTypes.TIME,
    },
    initial_incident_severity: {
      type: DataTypes.STRING(255),
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
    },
    incident_location: {
      type: DataTypes.TEXT("long"),
    },
    investigation_team_details: {
      type: DataTypes.ENUM("Internal", "External"),
    },
    employee: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    role_in_incident: {
      type: DataTypes.STRING(255),
    },
    investigator_name: {
      type: DataTypes.STRING(255),
    },
    specialty: {
      type: DataTypes.STRING(255),
    },
    specify: {
      type: DataTypes.STRING(255),
    },
    organization_external: {
      type: DataTypes.STRING(255),
    },
    investigation_start_date: {
      type: DataTypes.DATEONLY,
    },
    investigation_end_date: {
      type: DataTypes.DATEONLY,
    },
    actual_incident_description: {
      type: DataTypes.TEXT("long"),
    },
    actual_incident_severity: {
      type: DataTypes.INTEGER,
    },
    // person_involved_internal_external: {
    //   type: DataTypes.INTEGER,
    //   defaultValue: "0",
    // },
    // involved_person: {
    //   type: DataTypes.STRING(255), //integer
    // },
    // involved_role: {
    //   type: DataTypes.STRING(255),
    // },
    // involved_department: {
    //   type: DataTypes.STRING(255),
    // },
    // involved_role_in_incident: {
    //   type: DataTypes.STRING(255),
    // },
    investigation_enquiry_outcome: {
      type: DataTypes.STRING(255),
    },
    drm_id: {
      type: DataTypes.INTEGER,
    },
    has_similar_incident_occurred_before: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    similar_incidents: {
      type: DataTypes.TEXT("long"),
    },
    actual_incident_category: {
      type: DataTypes.TEXT("long"),
      // references: {
      //   model: IncidentCategory,
      //   key: IncidentCategory.primaryKeyAttribute,
      // },
    },
    actual_incident_details: {
      type: DataTypes.TEXT("long"),
    },
    reportable: {
      type: DataTypes.TEXT("long"),
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
    },
    root_cause_validation: {
      type: DataTypes.TEXT("long"),
    },
    root_cause_prioritization: {
      type: DataTypes.TEXT("long"),
    },
    root_cause_selection: {
      type: DataTypes.TEXT("long"),
    },
    recommended_actions: {
      type: DataTypes.TEXT("long"),
    },
    investigation_form_submitted_by: {
      type: DataTypes.TEXT("long"),
    },
    report_date: {
      type: DataTypes.DATEONLY,
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
    },
    notify: {
      type: DataTypes.TEXT("long"),
    },
    checkpoint_post_investigation: {
      type: DataTypes.TEXT("long"),
    },
    recall_required: {
      type: DataTypes.STRING(255),
    },
    applicable_sop_created: {
      type: DataTypes.STRING(255),
    },
    affected_employees_retrained: {
      type: DataTypes.STRING(255),
    },
    investigation_outcome_communicated: {
      type: DataTypes.BOOLEAN,
    },
    recommended_can_be_applied: {
      type: DataTypes.STRING(255),
    },
    role_in_incident_external: {
      type: DataTypes.STRING(255),
    },
    // investigation_organization: {
    //   type: DataTypes.STRING(255),
    // },
    assets_damage_assets_property_type: {
      type: DataTypes.STRING(255),
    },
    asset_damage_details: {
      type: DataTypes.TEXT,
    },
    estimated_cost_damage: {
      type: DataTypes.DECIMAL(10, 2),
    },
    assets_value: {
      type: DataTypes.DECIMAL(10, 2),
    },
    assets_currency: {
      type: DataTypes.STRING(10),
    },
    assets_vehicle_incident_driver_details: {
      type: DataTypes.TEXT,
    },
    assets_vehicle_details: {
      type: DataTypes.TEXT,
    },
    assets_vehicle_incident_type: {
      type: DataTypes.STRING(255),
    },
    quality_incident_type: {
      type: DataTypes.STRING(255),
    },
    quantity_affected: {
      type: DataTypes.INTEGER,
    },
    customer_impact: {
      type: DataTypes.STRING(255),
    },
    product_impact: {
      type: DataTypes.STRING(255),
    },
    estimated_financial_impact: {
      type: DataTypes.DECIMAL(10, 2),
    },
    quality_value: {
      type: DataTypes.DECIMAL(10, 2),
    },
    quality_currency: {
      type: DataTypes.STRING(10),
    },
    quality_vehicle_incident_driver_details: {
      type: DataTypes.TEXT,
    },
    quality_vehicle_details: {
      type: DataTypes.TEXT,
    },
    quality_vehicle_incident_type: {
      type: DataTypes.STRING(255),
    },
    environment_consequence_type: {
      type: DataTypes.STRING(255),
    },
    origin: {
      type: DataTypes.STRING(255),
    },
    size_area_affected: {
      type: DataTypes.DECIMAL(10, 2),
    },
    injury_classification: {
      type: DataTypes.STRING(255),
    },
    part_body_affected: {
      type: DataTypes.STRING(255),
    },
    reportable_classification: {
      type: DataTypes.STRING(255),
    },
    hospitalized: {
      type: DataTypes.BOOLEAN,
    },
    exposed_person: {
      type: DataTypes.STRING(255),
    },
    diseases_illnesses_type: {
      type: DataTypes.STRING(255),
    },
    date_diagnosed: {
      type: DataTypes.DATEONLY,
    },
    exposure_route: {
      type: DataTypes.STRING(255),
    },
    security_incident_type: {
      type: DataTypes.STRING(255),
    },
    security_value: {
      type: DataTypes.DECIMAL(10, 2),
    },
    security_currency: {
      type: DataTypes.STRING(10),
    },
    initialRootCauses: {
      type: DataTypes.TEXT("long"),
    },
    fishbone_categories: {
      type: DataTypes.TEXT("long"),
    },
    root_cause_validation: {
      type: DataTypes.TEXT("long"),
    },
    root_cause: {
      type: DataTypes.TEXT("long"),
    },
    likelihood_occurrence: {
      type: DataTypes.STRING,
    },
    impact_severity: {
      type: DataTypes.STRING,
    },
    risk_score: {
      type: DataTypes.INTEGER,
    },
    final_root_cause: {
      type: DataTypes.TEXT("long"),
    },
    final_recommendations: {
      type: DataTypes.TEXT("long"),
    },
    investigation_submitted: {
      type: DataTypes.TEXT("long"),
    },
    report_date: {
      type: DataTypes.DATEONLY,
    },
    submission_date: {
      type: DataTypes.DATEONLY,
    },
    notify: {
      type: DataTypes.TEXT("long"),
    },
    investigation_standardise: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      // should be in action replicate this section
    },
    investigation_root_cause: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    initial_standardize: {
      type: DataTypes.TEXT("long"),
    },
    line_manager_type: {
      type: DataTypes.STRING(255),
    },
    injured_persons: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    quality_incident_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_type: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    occupationals: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    vehicle_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    asset_type: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_security_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    any_arrests: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    any_recoveries: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    financial_value: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    estimated_currency: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    evidence_collected: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    upload_document: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("Draft", "Complete"),
      allowNull: false,
      defaultValue: "Draft",
    },
    investigation_ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      // reference from repository table
    },
    incident_persons_involved: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    root_cause_methodology: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    investigation_enquiry_details: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    signature_type: {
      type: DataTypes.ENUM("Electronic", "Manual"),
      allowNull: false,
      defaultValue: "Manual",
    },
    ...EndFields,
  },
  {
    tableName: "investigation",
    modelName: "Investigation",
    sequelize,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await Investigation.sync({ alter: true }));

export default Investigation;
