import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Legislation from "./LegislationSchema.js";
import Repository from "./RepositorySchema.js";

const LegislationDoc = sequelize.define(
  "LegislationDoc",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    legislation_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Legislation,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // document_title: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    // documents: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    old_version: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    new_version: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "legislation_doc",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await LegislationDoc.sync({ alter: true }));
export default LegislationDoc;
