import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const Meeting = sequelize.define(
  "Meeting",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    meeting_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    meeting_title: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    meeting_hierarchy: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    meeting_owner: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    planned_meeting_date_from: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    planned_meeting_date_to: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    venue: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    agenda: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    linked_table: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    record: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "meeting",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Meeting.belongsTo(User, { foreignKey: "meeting_owner", as: "MeetingOwner" });
Meeting.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
Meeting.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });
Meeting.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
Meeting.belongsTo(Department, { foreignKey: "department", as: "Department" });

// console.log(await Meeting.sync({ alter: true }));
export default Meeting;
