import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import PermitLicenseCompliance from "./PermitLicenseComplianceSchema.js";

const PermitLicenseDocs = sequelize.define(
  "PermitLicenseDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    permit_license_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: PermitLicenseCompliance,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    image: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "permit_license_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

PermitLicenseDocs.belongsTo(PermitLicenseCompliance, {
  foreignKey: "permit_license_id",
  as: "PermitLicenseCompliance",
});

export default PermitLicenseDocs;
