import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import IssuingAuthority from "./IssuingAuthoritySchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const QualityTechnicalForm = sequelize.define(
  "QualityTechnicalForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },

    permit_title: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    permit_holder: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    permit_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    permit_number: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    permit_type: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    issuing_authority: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IssuingAuthority,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    applicable_legislation_section: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    issue_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    validity_from: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    validity_until: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notification_alert: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    condition_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    renewal_due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    permit_renewal_process: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    documents: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "quality_technical_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

QualityTechnicalForm.belongsTo(IssuingAuthority, {
  foreignKey: "issuing_authority",
  as: "IssuingAuthority",
});

QualityTechnicalForm.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

QualityTechnicalForm.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

QualityTechnicalForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

QualityTechnicalForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await QualityTechnicalForm.sync({ alter: true }));

export default QualityTechnicalForm;
