import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const SHELegalRegister = sequelize.define(
  "SHELegalRegister",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    risk_given_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    function_record: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    title: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    regulatory_body: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    legislation_sector_type: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    hierarchy_of_legislation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    subordinate: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    heading: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    level_of_legislation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    description_of_level: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    provision_of_the_requirement: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    interpretation_of_the_provision: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    comment_action_implication: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    consequences_of_non_compliance: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "she_legal_register",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SHELegalRegister.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

SHELegalRegister.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default SHELegalRegister;
