import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";

const ShortUrl = sequelize.define(
  "ShortUrl",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    original_url: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    shorten_url: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    clicks: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "short_url",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default ShortUrl;
