import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js"; // Adjust imports according to your project
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Sidebar from "./SidebarSchema.js";

// Define the Software Access Request model
const SoftwareAccessRequest = sequelize.define(
  "SoftwareAccessRequest",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    reason: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    sidebar_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    status: {
      type: DataTypes.ENUM("pending", "approved", "rejected"),
      defaultValue: "pending",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
  },
  {
    tableName: "software_access_request",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
SoftwareAccessRequest.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
SoftwareAccessRequest.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});
SoftwareAccessRequest.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
SoftwareAccessRequest.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});

SoftwareAccessRequest.belongsTo(Sidebar, {
  as: "sidebarDetails",
  foreignKey: "sidebar_id",
});

SoftwareAccessRequest.belongsTo(User, {
  as: "userDetails",
  foreignKey: "user_id",
});

// console.log(await SoftwareAccessRequest.sync({ alter: true }));

export default SoftwareAccessRequest;
