import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Role from "./RoleSchema.js";
import Skill from "./SkillSchema.js";
import Repository from "./RepositorySchema.js";

const TaskTemplate = sequelize.define(
  "TaskTemplate",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    template_version: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    send_to_employee: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    for_approval: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    visibility: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    category: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    sub_category: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    // attachment: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    assigned_to: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    dependencies: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    successor_task_template: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    predecessor_task_template: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    task_type: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    module_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    sub_module_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    record_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    role: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Role,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    skill: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Skill,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    task_title: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    task_description: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    priority: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    task_duration: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "Pending",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    tableName: "task_template_list",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Relationships with other models
TaskTemplate.belongsTo(User, { as: "creator", foreignKey: "created_by" });
TaskTemplate.belongsTo(User, { as: "updater", foreignKey: "updated_by" });
TaskTemplate.belongsTo(User, {
  as: "assigned",
  foreignKey: "assigned_to",
});
TaskTemplate.belongsTo(Organization, {
  as: "org",
  foreignKey: "organization",
});
TaskTemplate.belongsTo(Department, {
  as: "dep",
  foreignKey: "department",
});
// console.log(await TaskTemplate.sync({ alter: true }));
export default TaskTemplate;
