import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import City from "./CitySchema.js";
import State from "./StateSchema.js";
import Country from "./CountrySchema.js";
import Repository from "./RepositorySchema.js";
// import Banks from "./BanksSchema.js";

const User = sequelize.define(
  "User",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    client_internal_id: {
      type: DataTypes.STRING(255),
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
      comment: "Employee ID",
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
      comment: "First name",
    },
    surname: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    national_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    id_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    passport_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    visa_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    date_of_birth: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    gender: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        key: "id",
        model: "gender",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL",
    },
    marital_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    language: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    race: {
      type: DataTypes.STRING(255),
      allowNull: true,
      //reference : Race
    },
    person_with_disabilities: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: true,
    },
    disability: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    highest_qualification: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        key: "id",
        model: "highest_qualification",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL",
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL",
    },
    name_of_qualification: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    residential_address: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    postal_address: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    country: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        key: "id",
        model: Country,
      },
    },
    state: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        key: "id",
        model: State,
      },
      comment: "Province",
    },
    city: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        key: "id",
        model: City,
      },
    },
    current_address: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    phone: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    emergency_contact_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    role: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    employment_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employment_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    date_of_employment: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    start_probation_period: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    end_probation_period: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    date_of_termination: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    reason_for_employee_becoming_inactive: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    // work_location: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    //   references: {
    //     key: "id",
    //     model: Location,
    //   },
    //   onUpdate: "CASCADE",
    //   onDelete: "SET NULL",
    // },
    hierarchy_level: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    manager: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    age: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    unique_id_status: {
      type: DataTypes.ENUM("automatic", "manual"),
      allowNull: true,
    },
    password: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    profile: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "profile/default_profile.png",
    },

    employee_contact_details: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    probation_period: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    date_of_termination: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    joining_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    employee_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    income_tax_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tax_residency_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    bank_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
      // references: {
      //   key: "id",
      //   model: Banks,
      // }
    },
    account_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    branch_code: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    account_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employment_checklist: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    allergies: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    current_medications: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    blood_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    vaccination_records: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    role_desc: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    level: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    accountability: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    skills: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    license: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    otp: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    my_organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    employee_department: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    permission: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    special_permission: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "If any users get any special permission then it will set 1",
    },
    notification_sender: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "[]",
    },
    organization_access: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    view_type: {
      type: DataTypes.ENUM("self", "team", "all"),
      allowNull: true,
      defaultValue: "all",
    },
    is_super_admin: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    work_permit_expiry_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    permit_license: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    active_step: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    pre_employment_check: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    post_employment_check: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },

    employee_department_info: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    completed_step: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy: {
      type: DataTypes.INTEGER,
    },
    incident: {
      type: DataTypes.INTEGER,
    },
    non_conformance: {
      type: DataTypes.INTEGER,
    },
    risk: {
      type: DataTypes.INTEGER,
    },
    team_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    unified_user_uique_id: {
      type: DataTypes.STRING(255),
    },
    deleted: {
      type: DataTypes.ENUM("0", "1"),
      allowNull: true,
      defaultValue: "0",
      comment:
        "This is for checking that user is deleted or not if user deleted is 0 then this user is not deleted",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
  },
  {
    tableName: "users",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await User.sync({ alter: true }));

export default User;
