import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";

const RegulatoryCompliance = sequelize.define(
  "RegulatoryCompliance",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_type: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    evidence_requirements: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    affected_parties: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    compliance_information: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    policy_and_procedure_documents: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    record_retention_policies: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    regulatory_guidance: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    other_documents: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
  },
  {
    tableName: "regulatory_compliance",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default RegulatoryCompliance;
